<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->timestamps();
			$table->softDeletes();
			$table->increments('id');
			$table->string('title');
			$table->string('email')->index();
			$table->string('firstname');
			$table->string('lastname');
			$table->string('password');
			$table->string('phone');
			$table->jsonb('address');
			$table->jsonb('other_info');
			$table->string('role');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}