<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentPlansTable extends Migration {

	public function up()
	{
		Schema::create('payment_plans', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->bigInteger('owner_id')->unsigned();
			$table->bigInteger('installment_duration_id')->unsigned();
			$table->decimal('down_payment', 8,2);
			$table->bigInteger('payment_cycle_id')->unsigned();
			$table->decimal('interest_ratio', 8,2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payment_plans');
	}
}