<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type_order', array('new', 'recovery', 'replace'));
			$table->string('buyer_name', 200);
			$table->string('buyer_phone', 20);
			$table->string('buyer_address', 200);
			$table->enum('delivery_type', array('company_stores', 'company_representative'));
			$table->string('amount_from_buyer', 200);
			$table->string('product_name', 200)->nullable();
			$table->string('quantity', 400)->nullable();
			$table->string('product_weight', 500)->nullable();
			$table->string('description', 1000)->nullable();
			$table->enum('breakable', array('yes', 'no'))->nullable();
			$table->integer('merchant_id')->unsigned();
			$table->enum('paid_in_advance', array('yes', 'no'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}