<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;

class Merchant extends Model 
{

    protected $table = 'merchants';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'customer_service_number', 'specialization', 'expected_requests', 'governorate_id', 'city_id', 'address', 'logo', 'commercial_license');

    public function order()
    {
        return $this->belongsTo('App/Model\Order');
    }

    public function governorate()
    {
        return $this->belongsTo('App/Model\Governorate');
    }

}