<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('offices_id')->references('id')->on('offices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('department_id_fk')->references('id')->on('department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grades_courses', function(Blueprint $table) {
			$table->foreign('grades_id_fk')->references('id')->on('grades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grades_courses', function(Blueprint $table) {
			$table->foreign('courses_id_fk')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('enrolled', function(Blueprint $table) {
			$table->foreign('students_id_fk')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('enrolled', function(Blueprint $table) {
			$table->foreign('grades_id_fk')->references('id')->on('grades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('marks', function(Blueprint $table) {
			$table->foreign('grades_id_fk')->references('id')->on('grades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('marks', function(Blueprint $table) {
			$table->foreign('courses_id_fk')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('marks', function(Blueprint $table) {
			$table->foreign('students_id_fk')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_offices_id_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_department_id_fk_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_group_id_foreign');
		});
		Schema::table('grades_courses', function(Blueprint $table) {
			$table->dropForeign('grades_courses_grades_id_fk_foreign');
		});
		Schema::table('grades_courses', function(Blueprint $table) {
			$table->dropForeign('grades_courses_courses_id_fk_foreign');
		});
		Schema::table('enrolled', function(Blueprint $table) {
			$table->dropForeign('enrolled_students_id_fk_foreign');
		});
		Schema::table('enrolled', function(Blueprint $table) {
			$table->dropForeign('enrolled_grades_id_fk_foreign');
		});
		Schema::table('marks', function(Blueprint $table) {
			$table->dropForeign('marks_grades_id_fk_foreign');
		});
		Schema::table('marks', function(Blueprint $table) {
			$table->dropForeign('marks_courses_id_fk_foreign');
		});
		Schema::table('marks', function(Blueprint $table) {
			$table->dropForeign('marks_students_id_fk_foreign');
		});
	}
}