<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaisesTable extends Migration {

	public function up()
	{
		Schema::create('paises', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nombre', 100);
			$table->string('iso_code', 2);
			$table->string('idioma', 2);
			$table->string('moneda', 3);
			$table->string('campo_pvp', 4);
			$table->decimal('incremento_porcentaje');
			$table->decimal('portes');
			$table->decimal('minimo');
			$table->string('operador_envio', 100);
			$table->string('entrega', 255);
			$table->string('hashid', 50);
			$table->string('captcha_site', 200);
			$table->string('captcha_secret', 200);
			$table->string('email_contacto', 100);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('paises');
	}
}