<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePedidosTable extends Migration {

	public function up()
	{
		Schema::create('pedidos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_mediodepago');
			$table->string('auth_code', 50);
			$table->timestamp('auth_date');
			$table->integer('id_cliente');
			$table->integer('id_estado');
			$table->integer('id_pais');
			$table->decimal('total');
			$table->decimal('portes');
			$table->decimal('extra_pago');
			$table->text('direccion_envio');
			$table->string('idioma', 5);
			$table->string('moneda', 3);
			$table->text('comentarios_cliente');
			$table->string('gclid', 2048);
			$table->string('campaign', 512);
			$table->string('user_agent', 512);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pedidos');
	}
}