<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientesDireccionesTable extends Migration {

	public function up()
	{
		Schema::create('clientes_direcciones', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_cliente');
			$table->smallInteger('orden');
			$table->string('direccion', 200);
			$table->string('localidad', 100);
			$table->string('cp', 10);
			$table->string('provincia', 100);
			$table->integer('id_pais');
			$table->enum('tipo', array('facturacion', 'entrega'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clientes_direcciones');
	}
}