<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('street_number')->nullable();
			$table->string('street_name', 512);
			$table->string('postal_code', 12)->nullable();
			$table->string('city_name', 255);
			$table->string('province', 255)->nullable();
			$table->string('country', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}