<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function employee()
    {
        return $this->hasOne('Employees', 'employee_id');
    }

    public function acess_level()
    {
        return $this->hasOne('Acess_level', 'acess_level_id');
    }

}