<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentMethod extends Model 
{

    protected $table = 'payment_methods';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'provider', 'type', 'external_id', 'country_code', 'exp_month', 'exp_year', 'last4', 'meta');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function orders()
    {
        return $this->hasMany('Order');
    }

}