<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'name', 'content', 'excerpt', 'published_at', 'members_only', 'author_id');

    public function tags()
    {
        return $this->morphToMany('Tag');
    }

    public function author()
    {
        return $this->hasOne('User');
    }

}