<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductCrossSellsTable extends Migration {

	public function up()
	{
		Schema::create('product_cross_sells', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('first_product')->unsigned();
			$table->string('first_product_type', 32);
			$table->integer('second_product')->unsigned()->index();
			$table->string('second_product_type', 32);
			$table->text('meta');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_cross_sells');
	}
}