<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDynamicPricingTable extends Migration {

	public function up()
	{
		Schema::create('dynamic_pricing', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('price_per_product')->unsigned()->nullable();
			$table->smallInteger('discount_percentage')->unsigned()->nullable();
			$table->boolean('member_only')->index();
			$table->integer('category_id')->unsigned()->index();
			$table->integer('product_id')->unsigned()->index();
			$table->string('product_type', 32);
			$table->smallInteger('required_quantity')->unsigned()->nullable();
			$table->tinyInteger('priority')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('dynamic_pricing');
	}
}