<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommissionsTable extends Migration {

	public function up()
	{
		Schema::create('commissions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned()->index();
			$table->integer('order_item_id')->unsigned()->nullable();
			$table->integer('product_partner_id')->unsigned()->index();
			$table->integer('product_id')->unsigned()->index();
			$table->string('product_type', 32)->index();
			$table->integer('commission_rate_id')->unsigned()->nullable()->index();
			$table->smallInteger('commission_percentage')->unsigned();
			$table->integer('commission_amount');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('commissions');
	}
}