<?php

namespace App\Models;

class VctOnDemand extends Eloquent {

	protected $table = 'vct_on_demands';
	public $timestamps = true;
	protected $fillable = array('customer_id', 'hospital_id', 'hospital_vct_staff_id', 'date_order', 'address_detail', 'latitude', 'longitude', 'status_order', 'checkup_date', 'checkup_time', 'price', 'tax', 'payment_status');
	protected $visible = array('customer_id', 'hospital_id', 'hospital_vct_staff_id', 'date_order', 'address_detail', 'latitude', 'longitude', 'status_order', 'checkup_date', 'checkup_time', 'price', 'tax', 'payment_status');

	public function hospital()
	{
		return $this->belongsTo('Hospital', 'hospital_id');
	}

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

	public function vct_staff()
	{
		return $this->belongsTo('App\Models\HospitalVctStaff', 'hospital_vct_staff_id');
	}

}