<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('full_name', 'phone', 'hospital_id', 'medical_records', 'ktp', 'golongan_darah', 'alergi');
	protected $visible = array('full_name', 'phone', 'hospital_id', 'golongan_darah');

	public function hospital()
	{
		return $this->belongsTo('App\Models\Hospital', 'hospital_id');
	}

}