<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCreditsTable extends Migration {

	public function up()
	{
		Schema::create('user_credits', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->bigIncrements('amount');
			$table->integer('user_creator')->unsigned();
			$table->text('description')->nullable();
			$table->enum('status', array('pending', 'accept', 'reject'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_credits');
	}
}