<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('father_name')->nullable();
			$table->string('national_id')->nullable();
			$table->boolean('gender')->default(0);
			$table->string('bank_name')->nullable();
			$table->string('bank_cart')->nullable();
			$table->string('bank_number_account')->nullable();
			$table->string('code_card_number')->nullable();
			$table->string('sheba')->nullable();
			$table->string('phone')->nullable();
			$table->string('post_code')->nullable();
			$table->integer('province')->nullable();
			$table->integer('city')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}