<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTravelsTable extends Migration {

	public function up()
	{
		Schema::create('Travels', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->integer('travel_plan_id')->unsigned();
			$table->integer('travel_group_id')->unsigned();
			$table->integer('country_id')->unsigned()->nullable();
			$table->string('1-7')->nullable()->default('0');
			$table->string('8-15')->nullable()->default('0');
			$table->string('16-23')->nullable()->default('0');
			$table->string('24-31')->nullable()->default('0');
			$table->string('32-45')->nullable()->default('0');
			$table->string('46-62')->nullable()->default('0');
			$table->string('63-92')->nullable()->default('0');
			$table->string('93-180')->nullable()->default('0');
			$table->string('181-365')->nullable()->default('0');
			$table->string('age')->nullable()->default('0');
			$table->double('discount_manager_percent')->nullable()->default('0');
			$table->double('discount_manager_amount')->nullable()->default('0');
			$table->tinyInteger('installments')->nullable()->default('0');
			$table->double('installment_percent')->nullable()->default('0');
			$table->integer('short_term')->nullable()->default('0');
			$table->double('shortterm_before')->nullable()->default('0');
			$table->tinyInteger('round_it')->nullable();
			$table->double('tax')->default('9');
			$table->string('position')->default('1000');
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Travels');
	}
}