<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLifesTable extends Migration {

	public function up()
	{
		Schema::create('Lifes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('insurance_id')->unsigned();
			$table->string('years')->nullable();
			$table->string('type')->nullable();
			$table->string('payment')->nullable();
			$table->bigInteger('periodic')->nullable();
			$table->bigInteger('all')->nullable();
			$table->bigInteger('death')->nullable();
			$table->bigInteger('s_death')->nullable();
			$table->bigInteger('s_danger')->nullable();
			$table->bigInteger('s_maim')->nullable();
			$table->bigInteger('s_diseases')->nullable();
			$table->bigInteger('s_cancer')->nullable();
			$table->bigInteger('s_medical')->nullable();
			$table->integer('input_type')->nullable();
			$table->double('tax')->nullable()->default('9');
			$table->boolean('round_it')->nullable()->default(1);
			$table->string('position')->default('1000');
			$table->boolean('is_active')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Lifes');
	}
}