<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function profile()
    {
        return $this->hasOne('App\UserProfile');
    }

    public function roles()
    {
        return $this->belongsToMany('App\Role');
    }

    public function complaint()
    {
        return $this->hasMany('App\Complaint');
    }

    public function examTable()
    {
        return $this->hasOne('App\ExamsTable');
    }

    public function weeklySchedule()
    {
        return $this->hasOne('App\WeeklySchedule');
    }

    public function degres()
    {
        return $this->hasMany('App\Degres');
    }

    public function absences()
    {
        return $this->hasMany('App\Absence');
    }

}