<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkillsTable extends Migration {

	public function up()
	{
		Schema::create('skills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('skill_name');
			$table->string('skill_slug')->nullable()->index();
			$table->integer('skill_type_id')->unsigned()->index();
			$table->integer('capacity')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('skills');
	}
}