<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Performance extends Model 
{

    protected $table = 'performances';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('calculated_score', 'manual_score', 'student_id', 'jiri_id');

    public function student()
    {
        return $this->belongsTo('Student');
    }

    public function event()
    {
        return $this->belongsTo('Jiri');
    }

}