<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeviceTokensTable extends Migration {

	public function up()
	{
		Schema::create('device_tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->text('token')->nullable();
			$table->enum('device_language', array('ar', 'en'))->nullable();
			$table->enum('device_type', array('ios', 'android'))->nullable();
			$table->enum('status', array('connected', 'disconnected'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('device_tokens');
	}
}