<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomizedTripsTable extends Migration {

	public function up()
	{
		Schema::create('customized_trips', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned();
			$table->enum('type', array('route', 'activity'))->nullable();
			$table->integer('category_id')->unsigned();
			$table->date('date_start')->nullable();
			$table->date('date_end')->nullable();
			$table->time('start_time')->nullable();
			$table->time('end_time')->nullable();
			$table->text('description')->nullable();
			$table->string('duration')->nullable();
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->string('male_count')->nullable();
			$table->string('female_count')->nullable();
			$table->string('children_count')->nullable();
			$table->integer('offer_id')->unsigned()->nullable();
			$table->integer('guide_id')->unsigned();
			$table->enum('status', array('new', 'completed', 'accepted', 'not_complete'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customized_trips');
	}
}