<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->string('name');
			$table->string('legal_name');
			$table->text('address_one');
			$table->text('address_two');
			$table->string('city')->nullable();
			$table->string('state')->nullable();
			$table->string('zip_code');
			$table->integer('phone_type_id')->unsigned();
			$table->integer('phone');
			$table->integer('hours')->nullable();
			$table->text('description')->nullable();
			$table->string('insurance');
			$table->string('logo')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}