<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('company_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('resources_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->time('start_time');
			$table->time('end_time');
			$table->decimal('price')->default('00.0');
			$table->tinyInteger('status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}