<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('resources', function(Blueprint $table) {
			$table->foreign('resources_category_id')->references('id')->on('resources_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('resources_id')->references('id')->on('resources')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('to')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('from')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visitors', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('visitors', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_visitors', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_visitors', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_members', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('group_visitors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('time_pass_id')->references('id')->on('time_pass')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('service_charge_id')->references('id')->on('service_charges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('time_pass', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity_log', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity_log', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_plan_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('resources', function(Blueprint $table) {
			$table->dropForeign('resources_resources_category_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_company_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_user_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_resources_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_to_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_from_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_user_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_company_id_foreign');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->dropForeign('invites_user_id_foreign');
		});
		Schema::table('visitors', function(Blueprint $table) {
			$table->dropForeign('visitors_user_id_foreign');
		});
		Schema::table('visitors', function(Blueprint $table) {
			$table->dropForeign('visitors_company_id_foreign');
		});
		Schema::table('group_visitors', function(Blueprint $table) {
			$table->dropForeign('group_visitors_user_id_foreign');
		});
		Schema::table('group_visitors', function(Blueprint $table) {
			$table->dropForeign('group_visitors_company_id_foreign');
		});
		Schema::table('group_members', function(Blueprint $table) {
			$table->dropForeign('group_members_group_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_invoice_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_payment_method_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_invoice_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_plan_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_booking_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_time_pass_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_service_charge_id_foreign');
		});
		Schema::table('time_pass', function(Blueprint $table) {
			$table->dropForeign('time_pass_user_id_foreign');
		});
		Schema::table('activity_log', function(Blueprint $table) {
			$table->dropForeign('activity_log_user_id_foreign');
		});
		Schema::table('activity_log', function(Blueprint $table) {
			$table->dropForeign('activity_log_company_id_foreign');
		});
	}
}