<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupVisitorsTable extends Migration {

	public function up()
	{
		Schema::create('group_visitors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('company_id')->unsigned()->nullable();
			$table->string('type');
			$table->string('name');
			$table->string('organization')->nullable();
			$table->string('address')->nullable();
			$table->date('date');
			$table->time('time');
			$table->string('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('group_visitors');
	}
}