<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessageLogTable extends Migration {

	public function up()
	{
		Schema::create('message_log', function(Blueprint $table) {
			$table->increments('id');
			$table->string('phone_number')->index();
			$table->integer('user_id')->unsigned();
			$table->text('body')->nullable();
			$table->integer('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('message_log');
	}
}