<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoomTypesTable extends Migration {

	public function up()
	{
		Schema::create('room_types', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('property_type_id')->unsigned();
			$table->string('name', 100)->index();
			$table->string('img', 100);
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('room_types');
	}
}