<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyFeatureTable extends Migration {

	public function up()
	{
		Schema::create('property_feature', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('property_id')->unsigned();
			$table->bigInteger('property_feature_id')->unsigned();
			$table->integer('value')->unsigned()->default('0');
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('property_feature');
	}
}