<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Campaign extends Eloquent {

	protected $table = 'campaigns';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function codes()
	{
		return $this->hasMany('App\Campaign');
	}

	public function stages()
	{
		return $this->hasMany('App\Campaign');
	}

	public function subscribers()
	{
		return $this->hasMany('App\Participant')->withPicot('CampaignSubscriber');
	}

}