<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVerificationsTable extends Migration {

	public function up()
	{
		Schema::create('verifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('document_path');
			$table->boolean('is_valid')->default(0);
			$table->datetime('expiration_date');
			$table->enum('type', array('DRIVER_LICENCE', 'IDENTITY'));
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('verifications');
	}
}