<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('verifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->foreign('depart_address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->foreign('arrival_address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passengers', function(Blueprint $table) {
			$table->foreign('passenger_journey_id')->references('id')->on('journeys')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('passengers', function(Blueprint $table) {
			$table->foreign('journey_id')->references('id')->on('journeys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passengers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passengers', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('opinions', function(Blueprint $table) {
			$table->foreign('journey_id')->references('id')->on('journeys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('opinions', function(Blueprint $table) {
			$table->foreign('passenger_id')->references('id')->on('passengers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('opinions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('opinions', function(Blueprint $table) {
			$table->foreign('writer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_address_id_foreign');
		});
		Schema::table('verifications', function(Blueprint $table) {
			$table->dropForeign('verifications_user_id_foreign');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->dropForeign('journeys_user_id_foreign');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->dropForeign('journeys_depart_address_id_foreign');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->dropForeign('journeys_arrival_address_id_foreign');
		});
		Schema::table('journeys', function(Blueprint $table) {
			$table->dropForeign('journeys_status_id_foreign');
		});
		Schema::table('passengers', function(Blueprint $table) {
			$table->dropForeign('passengers_passenger_journey_id_foreign');
		});
		Schema::table('passengers', function(Blueprint $table) {
			$table->dropForeign('passengers_journey_id_foreign');
		});
		Schema::table('passengers', function(Blueprint $table) {
			$table->dropForeign('passengers_user_id_foreign');
		});
		Schema::table('passengers', function(Blueprint $table) {
			$table->dropForeign('passengers_status_id_foreign');
		});
		Schema::table('opinions', function(Blueprint $table) {
			$table->dropForeign('opinions_journey_id_foreign');
		});
		Schema::table('opinions', function(Blueprint $table) {
			$table->dropForeign('opinions_passenger_id_foreign');
		});
		Schema::table('opinions', function(Blueprint $table) {
			$table->dropForeign('opinions_user_id_foreign');
		});
		Schema::table('opinions', function(Blueprint $table) {
			$table->dropForeign('opinions_writer_id_foreign');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->dropForeign('devices_user_id_foreign');
		});
	}
}