<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Status extends Model 
{

    protected $table = 'statuses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function passengers()
    {
        return $this->hasMany('Passenger');
    }

    public function journeys()
    {
        return $this->hasMany('Journey');
    }

}