<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('phone')->unique();
			$table->string('email')->unique();
			$table->string('password');
			$table->enum('type', array('client', 'storeowner', 'admiin'));
			$table->string('image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}