<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTable extends Migration {

	public function up()
	{
		Schema::create('sites', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid')->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->string('title')->index();
			$table->string('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('sites');
	}
}