<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModelHasUsersTable extends Migration {

	public function up()
	{
		Schema::create('model_has_users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('ref_model');
			$table->string('ref_id');
			$table->string('ref_table')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('model_has_users');
	}
}