<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaxonomyTable extends Migration {

	public function up()
	{
		Schema::create('taxonomy', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('uuid')->unique();
			$table->string('title')->nullable()->index();
			$table->string('slug')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('taxonomy');
	}
}