<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilePivotsTable extends Migration {

	public function up()
	{
		Schema::create('file_pivots', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('uuid')->unique();
			$table->integer('file_id')->nullable()->index();
			$table->integer('ref_id')->nullable()->index();
			$table->string('ref_table')->nullable();
			$table->string('ref_model')->nullable();
			$table->string('relationship')->nullable();
			$table->integer('index')->nullable()->default('0');
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->string('is_primary')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('file_pivots');
	}
}