<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;
    protected $fillable = array('note');

    public function user()
    {
        return $this->hasMany('User');
    }

    public function holding()
    {
        return $this->hasOne('Holding');
    }

    public function address()
    {
        return $this->hasMany('Adress');
    }

    public function farm()
    {
        return $this->hasOne('Farm');
    }

}