<?php

namespace App\Restaurant;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Offer extends Eloquent {

	protected $table = 'offers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('image', 'name', 'description', 'from', 'restaurant_id', 'to');

	public function restaurant()
	{
		return $this->belongsTo('App\Restaurant\Restaurant', 'restaurant_id');
	}

}