<?php

namespace App\General;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class District extends Eloquent {

	protected $table = 'districts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'city_id');

	public function city()
	{
		return $this->belongsTo('App\General\City', 'city_id');
	}

	public function restaurants()
	{
		return $this->hasMany('App\Restaurant\Restaurant');
	}

}