<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_id');
			$table->string('name')->nullable();
			$table->string('production_name')->nullable();
			$table->string('city')->nullable();
			$table->string('venue')->nullable();
			$table->string('event_date')->nullable();
			$table->string('ct_event_date')->nullable();
			$table->longText('data')->nullable();
			$table->tinyInteger('is_active')->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}