<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_id')->unsigned();
			$table->integer('commission_id')->unsigned();
			$table->string('quantity')->nullable();
			$table->string('section')->nullable();
			$table->string('row')->nullable();
			$table->string('price_actual')->nullable();
			$table->string('price_sale')->nullable();
			$table->string('url')->nullable();
			$table->longText('description')->nullable();
			$table->string('delivery_option')->nullable();
			$table->integer('created_by')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}