<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('commission_id')->references('id')->on('commission_master')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('seller_status')->references('id')->on('status_master')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('buyer_status')->references('id')->on('status_master')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('sale_id')->references('id')->on('sales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('payout_id')->references('id')->on('payouts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payouts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payouts', function(Blueprint $table) {
			$table->foreign('sale_id')->references('id')->on('sales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payouts', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('revenue', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('revenue', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('revenue', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_event_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_commission_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_created_by_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_ticket_id_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_buyer_id_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_seller_id_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_seller_status_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_buyer_status_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_sale_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_payout_id_foreign');
		});
		Schema::table('payouts', function(Blueprint $table) {
			$table->dropForeign('payouts_user_id_foreign');
		});
		Schema::table('payouts', function(Blueprint $table) {
			$table->dropForeign('payouts_sale_id_foreign');
		});
		Schema::table('payouts', function(Blueprint $table) {
			$table->dropForeign('payouts_created_by_foreign');
		});
		Schema::table('revenue', function(Blueprint $table) {
			$table->dropForeign('revenue_ticket_id_foreign');
		});
		Schema::table('revenue', function(Blueprint $table) {
			$table->dropForeign('revenue_buyer_id_foreign');
		});
		Schema::table('revenue', function(Blueprint $table) {
			$table->dropForeign('revenue_seller_id_foreign');
		});
	}
}