<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid');
			$table->integer('task_category_id');
			$table->string('subject');
			$table->integer('is_recurring');
			$table->enum('recurrence_type', array('weekly', 'monthly'));
			$table->integer('has_reminder');
			$table->datetime('starting_date');
			$table->datetime('expected_finish_date');
			$table->text('brief');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}