<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBillsDetailsTable extends Migration {

	public function up()
	{
		Schema::create('bills_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('bill_id')->index();
			$table->integer('item_id')->index();
			$table->string('quantity', 10);
			$table->decimal('price');
			$table->decimal('total');
			$table->integer('user_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bills_details');
	}
}